/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	WorldPath
**
** DESCRIPTION:	Path of points for world navigation
**
**      AUTHOR:	Greg Hospelhorn
**
\******************************************************************************/

#ifndef WORLD_PATH_H
#define WORLD_PATH_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ContentMap.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int WorldPath_c_iMaxPathLength = 500;
const int WorldPath_c_iPathGradientNull      = 0x7fff;
const int WorldPath_c_iPathGradientMax       = WorldPath_c_iPathGradientNull - 1;
const int WorldPath_c_iPathGradientMin       = 1;
const int WorldPath_c_iPathGradientCellCount = ContentMap_c_iWidthInBlocks * ContentMap_c_iHeightInBlocks;
const int WorldPath_c_iPathGradientNoTarget  = -1;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CWorldPath
{
private:

	//class structures
	struct PathGradient
	{
		ldwPoint destination;
#if _DEBUG
		int pathLength;
#endif	
		ldwUINT16 cell[WorldPath_c_iPathGradientCellCount];		
	};

	//class data
	ldwPoint mPoints[WorldPath_c_iMaxPathLength];

	int mLength;
	int mCurrentIndex;

	bool mDeepWaterOK;

	static PathGradient mPathGradient;

public:
	
	CWorldPath();

	bool FindPath(ldwPoint currentLocation,ldwPoint destination,bool canSwim = false);

	ldwPoint NextPoint();
	bool	 Completed();

	// path gradient methods

	public:     bool	 CreatePath(CWorldPath &path,ldwPoint currentLocation,ldwPoint destination,bool deepWaterOK);

	private:	bool     CreatePathGradient(PathGradient &gradient,ldwPoint destination,ldwPoint currentLocation,bool deepWaterOK);
	private:	bool     OnPathGradientTarget(PathGradient &gradient,ldwPoint currentLocation);
	private:	ldwPoint GetNextPointFromPathGradient(PathGradient &gradient,ldwPoint currentLocation,bool isRetry = false);

	private:	bool 	 PathIsBlocked(int column,int row,bool deepWaterOK);
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/
